/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
package djbuch.kapitel_07;
import java.util.*; 
import lotus.domino.*;
/**
 * 
 * @author Thomas Ekert
 *
 */
public class DocumentLocking {
	
	private static final String PASSWORT = "geheim";
	private static final String TESTUSER = "CN=Test User/O=DJBUCH";
	private static final String DIIOPSERVER = "www.djbuch.de";
	
	/**
	 * Anwendung zur Demonstration des Verhaltens beim Locking.
	 * DIIOP Server erforderlich.
	 * @param argv
	 */
	public static void main(String argv[]) {
		Session session = null;
		Database db = null;
		Document doc = null, otherDoc = null;
		DateRange s = null;
		try {
			session = NotesFactory.createSession(DIIOPSERVER, TESTUSER, PASSWORT);
			db = session.getDatabase(session.getServerName(), "djbuch/djbuch.nsf");
			doc = beispiel1 (db);
			if (doc != null) {doc.recycle();}
			doc = beispiel2 (db);
		} catch (NotesException e) {
			e.printStackTrace(System.err);
		} finally {
			try {
				if (doc != null) {doc.recycle();}
				if (otherDoc != null) {otherDoc.recycle();}
				if (db != null) {db.recycle();}
				if (session != null) {session.recycle();} 
			} catch (NotesException e) {
				System.err.println("Fataler Fehler.");
			}
		}
	}
	
	/**
	 * Locking Demo.
	 * Erzeugt ein Dokument, sperrt es fr den aktuellen Benutzer und
	 * gibt es wieder frei.
	 * @param db - Database
	 * @throws NotesException
	 */
	private static Document beispiel1 (Database db) throws NotesException {
		System.out.println (LINE + "\nBeispiel 1" + LINE);
		String adminServer = db.getACL().getAdministrationServer();
		boolean activated = db.isDocumentLockingEnabled();
		if (activated && adminServer != null && !adminServer.equals("")) {
			System.out.println ("Locking Server ist: " + adminServer);
			Document result = db.createDocument();
			result.replaceItemValue("Form", "FO_Dokument_k2");
			result.replaceItemValue("F_Titel", "Automatisch (1) erstellt am " 
					+ Calendar.getInstance().getTime());
			Vector v = new Vector ();
			v.add (TESTUSER);
			Item i = result.replaceItemValue("F_autor",v);
			i.setAuthors(true);
			result.save();
			boolean locked=false;
			try {
				locked = result.lock(false);
			} catch (NotesException e) {
				System.out.println ("Achtung: Endgltiges Locking nicht mglich.");
				try {
					locked = result.lock(true);
				} catch (NotesException e1) {
					System.out.println ("Achtung: Provisorisches Locking nicht mglich.");
					System.out.println ("Dokument bereits fr " + result.getLockHolders()+ " gesperrt.");
				}
			}
			String holders = result.getLockHolders().toString();
			System.out.println ("Gesperrt durch: " + holders);
			try {
				result.unlock();
				System.out.println ("Sperre fr " + holders + " konnte aufgehoben werden.");
			} catch (NotesException e) {
				System.out.println ("Sperre fr " + holders + " konnte nicht aufgehoben werden.");
			}
			System.out.println ("Gesperrt durch: " + result.getLockHolders());
			return result;
		} else {
			System.out.println ("Locking fr Datenbank aktiviert: " + activated);
			System.out.println ("Locking Server: <<" + adminServer +">>");
		}
		return null;
	}

	/**
	 * Locking Demo.
	 * Erzeugt ein Dokument, das fr einen fremden Benutzer gelocked ist
	 * und zeigt beim Versuch, dies fr den aktuellen Benutzer zu locken
	 * eine entsprechende Fehlermeldung.
	 * @param db - Database
	 * @throws NotesException
	 */
	private static Document beispiel2 (Database db) throws NotesException {
		System.out.println (LINE + "\nBeispiel 2" + LINE);
		String adminServer = db.getACL().getAdministrationServer();
		boolean activated = db.isDocumentLockingEnabled();
		if (activated && adminServer != null && !adminServer.equals("")) {
			Document result = db.createDocument();
			result.replaceItemValue("Form", "FO_Dokument_k2");
			result.replaceItemValue("F_Titel", "Automatisch (2) erstellt am " 
					+ Calendar.getInstance().getTime());
			Vector v = new Vector ();
			v.add (TESTUSER);
			Item i = result.replaceItemValue("F_autor",v);
			i.setAuthors(true);
			result.save();
			result.lock("Someone Else/DJBUCH",true);
			boolean locked=false;
			try {
				locked = result.lock(false);
			} catch (NotesException e) {
				System.out.println ("Achtung: Endgltiges Locking nicht mglich.");
				try {
					locked = result.lock(true);
				} catch (NotesException e1) {
					System.out.println ("Achtung: Provisorisches Locking nicht mglich.");
					System.out.println ("Dokument bereits fr " + result.getLockHolders()+ " gesperrt.");
				}
			}
			String holders = result.getLockHolders().toString();
			System.out.println ("Gesperrt durch: " + holders);
			try {
				result.unlock();
				System.out.println ("Sperre fr " + holders + " konnte aufgehoben werden.");
			} catch (NotesException e) {
				System.out.println ("Sperre fr " + holders + " konnte nicht aufgehoben werden. " + e.text);
			}
			System.out.println ("Gesperrt durch: " + result.getLockHolders());
			return result;
		} else {
			System.out.println ("Locking fr Datenbank aktiviert: " + activated);
			System.out.println ("Locking Server: <<" + adminServer +">>");
		}
		return null;
	}

	private static final String LINE = "\n************************************************************";
}
